using UnityEngine;
using System.Collections;

public class s_Level : MonoBehaviour
{
	static public int score; //Current score
	static public int highScore = 9999; //9999 so you get the highscore (lowscore actually)
	
	public float speed = 1; //Rotation speed
	public int currentTime; //Game timer
	public Texture2D clock; //Picture of the clock
	public GameObject musicMan; //For the music
		
	GameObject player; //So you can get the players position
	
	void Start()
	{
		player = GameObject.Find("Player");
		StartCoroutine(Timer()); //Starts the timer
		
		if (GameObject.Find("MusicManager") == null)
			Instantiate((GameObject)musicMan);
	}
	
	void Update ()
	{
		//IMPORTANT, took me a loooong time to figure this one out:
		//If the ball stops, the rigidbody goes to "sleep" and won't move.
		//It would just get stuck; now that it gets awakened, it is fixed!!!!
		if (Input.GetKeyDown(KeyCode.RightArrow) || Input.GetKeyDown(KeyCode.LeftArrow))
		{
			player.rigidbody.WakeUp();
		}
		
		//Rotate counter-clockwise
		if (Input.GetKey(KeyCode.RightArrow))
		{	
			transform.RotateAround(player.transform.position, Vector3.forward, speed);
		}
		
		//Rotate clockwise
		if (Input.GetKey(KeyCode.LeftArrow))
		{
			transform.RotateAround(player.transform.position, -Vector3.forward, speed);
		}
	}
	
	//Waits until the time is up, then you lose
	IEnumerator Timer()
	{
	    while(currentTime > 0)
		{
			yield return new WaitForSeconds(1); 
			++score;
	        --currentTime;
	    }
    	//Game Over
		Application.LoadLevel("Scene_Lose");
	}
	
	//Draws the clock and your time remaining
	void OnGUI()
	{
		GUI.DrawTexture(new Rect(5, 5, 32, 32), clock);
		GUI.Label(new Rect(45, 10, 64, 64), currentTime.ToString());
	}
}
